#! /bin/bash

declare -a gpu_list=(0 1)
declare -a cpu_list=("0-19" "20-39")
# declare -a gpu_list=(1 0)
# declare -a cpu_list=("20-39")

config_root=../config/reddit/SDMP

root_result_path=../result/reddit_SAGE_SDMP
GNN_target_path=../result/reddit/SAGE

host_name=`uname -n`

declare -a config_name=("reddit_SDMP_base.yml" "reddit_SDMP_no_feature_norm.yml")
# declare -a config_name=("reddit_SDMP_no_feature_norm.yml")
for ((idx=0; idx<${#config_name[@]}; ++idx)); do
    data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
    cur_result_path=${host_name}_${data_time}
    taskset -c ${cpu_list[$idx]} python ../main_gen_SDMP.py --data ../dataset --config ${config_root}/${config_name[$idx]} --device "cuda:${gpu_list[$idx]}" --result "${root_result_path}/${cur_result_path}" --gnn $GNN_target_path > /dev/null &
    pids[$idx]=$!
    sleep 1
done # end of for over train config
echo "Done this round of start!"
for pid in ${pids[*]}; do
    wait $pid
done
